<?php
// file       : checkosm.php
// version    : 2.00
// history    : 2.00 20110115 xml directly read (drop xml parser)
//                            JOSM didn't open the new html window
//                            check the maximum runtime
//                            add <numberUnitDistance>
//                            add browse parameter reading
//              1.02 20101023 outputtyp can changed between text and html
//              1.01 20101009 direktly read of *.gz files
//              1.00 first shared version
// author     : Georg Verweyen
//              georg (at) familieverweyen.de
//              www.familieverweyen.de
// description: reads the .osc files of OSM (OpenStreetMap.org)
//              and print founded unusually key or values 
//              needs additional files:
//              * ./check_value.txt     Version 1.xx
//              * ./check_replace.txt   Version 1.xx
//              * ./logoemail.png       for HTML-output only
//              * ./logoerror.png       for HTML-output only
//              * ./logojosm.png        for HTML-output only
//              * ./MF_node.png         for HTML-output only
//              * ./MF_relation.png     for HTML-output only
//              * ./MF_way.png          for HTML-output only
//              commandline: first parameter ist filename
//              browser    : ?file=<filename>
$mtime = explode(" ",microtime());
$timebegin = $mtime[1] + $mtime[0];
error_reporting(E_ERROR | E_WARNING | E_PARSE);
define (OUTPUTTYP, 'HTML'); // value 'TEXT' or 'HTML'
$confmailaddress='&#103;&#101;&#111;&#114;&#103;&#64;&#102;&#97;&#109;&#105;&#108;'.
                 '&#105;&#101;&#118;&#101;&#114;&#119;&#101;&#121;&#101;&#110;&#46;&#100;&#101;';
$confmailsubject='info to osmcheck message';
$file='';
$file = $argv[1];
if ($file=='') {
  $file=htmlentities($_GET['file']);
}
if (OUTPUTTYP=='TEXT') {
  echo 'Loading '.$file." ...\n";
} else {
  // "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd"
  echo '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">'."\n".
       '<html><head><title>OSC analyse</title><link rel="stylesheet" type="text/css" href="checkosm.css" /></head>'.
       '<iframe style=\'display:none\' id=\'hJOSM\' name=\'hJOSM\'></iframe><body>';
  echo '<p>Analyzing '.$file." ...<br /></p>";
}
$depth = array();
$msg_header = array ();
$msg_detail = array ();
global $currid;
global $currtype;
global $currversion;
global $lat;
global $long;
global $count;
global $cntnodedel;
global $cntnodeadd;
global $cntwaydel;
global $cntwayadd;
global $cntreladel;
global $cntrelaadd;
global $cntactdel;
global $cntactadd;
global $cnttag;
global $cntnocheck;
global $cntfailed;
global $cntcheck;
global $arrvalue;
global $arrunused;
global $max_arrunused;
global $flg_insert;
global $time_low;
global $time_high;
global $confmailaddress;
global $confmailsubject;

$starttime=date('Y-m-d H:i:s');

$flg_insert=true;
$xml_parser = xml_parser_create();
xml_set_element_handler($xml_parser, "startElement", "endElement");
xml_set_character_data_handler($xml_parser, "contents");

$cnttag=0;
$cntnocheck=0;
$cntcheck=0;
$cntfailed=0;
$cntactdel=0;
$cntactadd=0;
$cntnodedel=0;
$cntnodeadd=0;
$cntwaydel=0;
$cntwayadd=0;
$cntreladel=0;
$cntrelaadd=0;
$typ_file=''; // typ of input unknown (can be OSC or OSM)
$max_arrunused=200;
$time_low='9999-12-31T23:59:59';
$time_high='0000-01-01T00:00:00';

if (strpos($file,'.bz2')!== False) {
  if (!($fp = bzopen($file, 'r'))) {
    die("could not open XML input");
  }
} else if (strpos($file,'.gz')!== False) {
  if (!($fp = gzopen($file, 'r'))) {
    die('could not open XML input');
  }
} else {
  if (!($fp = fopen($file, "r"))) {
    die("could not open XML input");
  }
}

if (OUTPUTTYP=='TEXT') {
  echo date('d.m.Y H:i:s')."\n";
}
// read replacement file
if (!($fi = fopen('check_replace.txt', 'r'))) {
  die('could not open configuration file \'check_replace.txt\''."\n");
}
$cnt_conf_line   =0;
$cnt_conf_noempty=0;
$cnt_conf_size   =0;
$cnt_array       =0;
$arrreplace      =array();
$arrkey          =array();
// replacement checked as function: start
$arrreplace['<number>']['start']=0;
$arrreplace['<number>']['end']  =0;
$arrreplace['<numberUnitSpeed>']['start']=0;
$arrreplace['<numberUnitSpeed>']['end']  =0;
$arrreplace['<numberUnitDistancd>']['start']=0;
$arrreplace['<numberUnitDistance>']['end']  =0;
// replacement checked as function: end
while ($data = fgets($fi)) {
  $cnt_conf_line++;
  // clean up from commentsign //
  $tmp=strpos($data,'//');
  if ($tmp!== false) {
    $data=substr($data,0,strpos($data,'//'));
  }
  $data=trim($data);
  if (strlen($data)>0) { // no empty line
    $cnt_conf_noempty++;
    if (strncmp('<',$data,1)==0) {
      $string=substr($data,0,strpos($data,'>')+1);
      $arrreplace[$string]['start']=$cnt_array+1;
      $arrreplace[$string]['end']=$cnt_array+1;
    } else {
      $cnt_array++;
      $words = preg_split("/[\s,]*\\\"([^\\\"]+)\\\"[\s,]*|" . "[\s,]*'([^']+)'[\s,]*|" . "[\s,]+/", 
                          $data, 0, PREG_SPLIT_NO_EMPTY | PREG_SPLIT_DELIM_CAPTURE
                         );
      $arrreplace[$string]['end']=$cnt_array;
      $arrkey[$cnt_array]=$words[0];
    }
  }
}
fclose($fi);
//print_r ($arrreplace); print_r ($arrkey); die();
if (!($fi = fopen('check_value.txt', 'r'))) {
  die('could not open configuration file \'check_value.txt\''."\n");
}
// read config file
$arrvalue=array();
$arrunused=array();
while ($data = fgets($fi)) {
  $cnt_conf_line++;
  // clean up from commentsign //
  $tmp=strpos($data,'//');
  if ($tmp!== false) {
    $data=substr($data,0,strpos($data,'//'));
  }
  $data=trim($data);
  if (strlen($data)>0) { // no empty line
    $cnt_conf_noempty++;
    $words = preg_split("/[\s,]*\\\"([^\\\"]+)\\\"[\s,]*|" . "[\s,]*'([^']+)'[\s,]*|" . "[\s,]+/", 
                        $data, 0, PREG_SPLIT_NO_EMPTY | PREG_SPLIT_DELIM_CAPTURE
                       );
    $str='e';     // exist
    if (count($words)>1) {  // HINT $words[2] könnte leer sein!! (nicht bei PREG_SPLIT_NO_EMPTY)
      $str='s';   // string
      if (strncmp($words[1],'<',1)==0) {
        $cnt_start=$arrreplace[$words[1]]['start'];
        $cnt_end  =$arrreplace[$words[1]]['end'];
        if (($cnt_start==0) && ($cnt_end==0)) {
          $str='f'; // function
          if (count($words)>1) {
            $arrvalue[$words[0].'#'.$words[1]]=count($words);
            if (strlen($words[1])==0) {
              $str='e';
            }
          }
          if (count($words)>2) {
            $arrvalue[$words[0].'#'.$words[1].'#:type:']=$words[2];
          }
        }
      } else {
        if (count($words)>1) {
          $arrvalue[$words[0].'#'.$words[1]]=count($words);
        }
        if (count($words)>2) {
          $arrvalue[$words[0].'#'.$words[1].'#:type:']=$words[2];
        }
      }
    } // end of (count($words)>1)
    if ($arrvalue[$words[0]]=='') {
      $tmp=strpos($words[0],':<');
      if ($tmp>=0) {
        $word_search=substr($words[0],$tmp+1,strpos($words[0],'>')-$tmp);
        $cnt1_start=$arrreplace[$word_search]['start'];
        $cnt1_end  =$arrreplace[$word_search]['end'];
      } else {
        $cnt1_start=-1;
        $cnt1_end  = 0;
      }
      if ($cnt1_start==-1) {
        $arrvalue[$words[0]]=$str;
      } else {
        for ($cnt1=$cnt1_start;$cnt1<=$cnt1_end;$cnt1++) {
          $arrvalue[str_replace($word_search,$arrkey[$cnt1],$words[0])]=$str;
        }
      }
    } else if ($arrvalue[$words[0]]<>$str) {
      switch ($arrvalue[$words[0]].$str) {
        case 'sf':
        case 'fs': 
        case 'ms': 
        case 'mf': {
          $arrvalue[$words[0]]='m'; // mixed string & function
          break;
        }
        default:   {
          echo 'error in the configuration file, tag: '.$words[0]."\n";
        }
      }
    }
    if ($cnt1_start==-1) {
      if (($cnt_start>0) || ($cnt_end>0)) {
        for ($cnt=$cnt_start;$cnt<=$cnt_end;$cnt++) {
          if (count($words)>1) {
            $str=$words[0].'#'.$arrkey[$cnt];
            $arrvalue[$str]=count($words);
          }
          if (count($words)>2) {
            $str=$words[0].'#'.$arrkey[$cnt].'#:type:';
            $arrvalue[$str]=$words[2];
          }
        } // end of for
      }
    } else {
      for ($cnt1=$cnt1_start;$cnt1<=$cnt1_end;$cnt1++) {
        if (($cnt_start>0) || ($cnt_end>0)) {
          for ($cnt=$cnt_start;$cnt<=$cnt_end;$cnt++) {
            if (count($words)>1) {
              $str=str_replace($word_search,$arrkey[$cnt1],$words[0]).'#'.$arrkey[$cnt];
              $arrvalue[$str]=count($words);
            }
            if (count($words)>2) {
              $str=str_replace($word_search,$arrkey[$cnt1],$words[0]).'#'.$arrkey[$cnt].'#:type:';
              $arrvalue[$str]=$words[2];
            }
          } // end of for $cnt
        }
      } // end for for $cnt1
    }
  }
}
fclose($fi);
$cnt_conf_size=count($arrvalue);
//print_r($arrvalue);die ();
if (OUTPUTTYP=='TEXT') {
  echo date('d.m.Y H:i:s')." - ".$cnt_conf_line." - ".$cnt_conf_noempty." - ".$cnt_conf_size."\n";
} else {
  // Ausgabe zur Statistik verlagert
  echo '<h1>assumedly mistakes</h1>'."\n";
  echo '<table><tr><th>typ</th><th align=\'center\'>ID</th><th>version</th><th>key</th><th>value</th><th width=\'48px\'>action</th></tr>'."\n";
}
// open data file
$maxruntime=ini_get('max_execution_time');
$error_counter=0;
$line_counter=0;
while (!feof($fp)) {
    $data = trim(fgets($fp, 4096));
    $line_counter++;
	do {// dummy while loop start
      switch ($data[1]) {
        case 't': {
          if (strpos($data, '<tag k="')!==false) {
            if ($flg_insert) {
		      $cnttag++;
              $attrs=explode('"',$data,5);
		      if (register_error_tag ($attrs[1], $attrs[3])) {
		        print_error ($attrs[1], $attrs[3]);
		      }
            }
		    break;
	      }
        }
        case 'n': {
          if (strpos($data, '<node id="')!==false) {
            $currtyp='N';
		    analyse_xml ($data);
		    register_object_node();
            register_time();
	        break;
	      }
          if (strpos($data, '<nd ref="')!==false) {
	        break;
	      }
          break;
        }
        case 'w': {
          if (strpos($data, '<way id="')!==false) {
            $currtyp='W';
		    analyse_xml ($data);
		    register_object_way();
            register_time();
	        break;
	      }
        }
        case '/': {
          if (strpos($data, '</way>')!==false) {
	        break;
	      }
          if (strpos($data, '</relation>')!==false) {
	        break;
	      }
          if (strpos($data, '</node>')!==false) {
	        break;
	      }
          if (strpos($data, '</modify>')!==false) {
		    break;
          } 
          if (strpos($data, '</create>')!==false) {
		    break;
          }
          if (strpos($data, '</delete>')!==false) {
		    break;
          } 
          if (strpos($data, '</osmChange>')!==false) {
		    break;
          }
          if (strpos($data, '</osm>')!==false) {
		    break;
          }
        }          
        case 'm': {
          if (strpos($data, '<member type="')!==false) {
	        break;
	      }
          if (strpos($data, '<modify>')!==false) {
            $flg_insert=true;
            $cntactadd++;
		    break;
          }
        } 
        case 'r': {
          if (strpos($data, '<relation id="')!==false) {
            $currtyp='R';
		    analyse_xml ($data);
		    register_object_relation();
            register_time();
	        break;
          }
	    }
        case 'c': {
          if (strpos($data, '<create>')!==false) {
            $flg_insert=true;
            $cntactadd++;
		    break;
          }
        }
        case 'd': {
          if (strpos($data, '<delete>')!==false) {
            $flg_insert=false;
            $cntactdel++;
		    break;
          }
        }          
        case '?': {
          if (strpos($data, '<?xml')!==false) {
		    break;
          }
        }
        case 'o': {
          if (strpos($data, '<osmChange ')!==false) {
            $typ_file='OSC';
		    break;
          }
          if (strpos($data, '<osm ')!==false) {
            $typ_file='OSM';
		    break;
          }
        } 
        default: {
          $tmp_print=true;
        }        
      } 
    } while (false); // dummy while loop end
	if ($tmp_print) {
      echo '<tr><td><img alt=\'error\' title=\'can not interpret this line\'  src=\'./logoerror.png\' /></td><td>&nbsp;</td><td>&nbsp;</td><td colspan=\'2\'>',htmlentities($data),'</td></tr>';
  	  $error_counter++; 
      $tmp_print=false;
	}
    if ($runtime>0) {
      if (($line_counter % 500)==0) {
        $mtime = explode(" ",microtime());
        $time = $mtime[1] + $mtime[0];
        if (($maxruntime-($time-$timebegin))<0.3) {
          echo '<tr><td><img alt=\'error\' title=\'runtime warning\'  src=\'./logoerror.png\' /></td><td>&nbsp;</td><td>&nbsp;</td><td colspan=\'2\'>',
               'need ',$time-$timebegin,' from ',$maxruntime,' seconds<br />data do not completed readed!</td></tr>';
          break;
        }
      }
    }
}
fclose($fp);
arsort($arrunused);
if (OUTPUTTYP=='TEXT') {
  print_r($arrunused);
} else {
  // Ausgabe Zwischenzeit und Konfigurationsparameter ungeklärt
  echo '</table>'."\n";
  echo '<h1>Unknown tag</h1>'; 
  echo '<table><tr><th align=\'center\'>key</th><th>count</th></tr>'."\n";
  foreach ($arrunused as $key => $val) {
    echo '<tr><td>'.$key.'</td><td align=\'right\'>'.$val.'</td></tr>'."\n";
  }
  echo '</table>'."\n";
}
if (OUTPUTTYP=='TEXT') {
  echo date('d.m.Y H:i:s')."  - ".$cnttag."  - ".$cntfailed."  - ".$cntnocheck."  - ".$cntcheck."\n";
} else {
  // Ausgabe Zwischenzeit und Konfigurationsparameter ungeklärt
  echo '<h1>Statistics</h1><p>'; 
  echo '<table><tr><th align=\'center\'>action</th><th>node</th><th>way</th><th>relation</th></tr>'."\n";
  echo '<tr><td>deleted</td><td align=\'right\'>'.number_format($cntnodedel).'</td><td align=\'right\'>'.
       number_format($cntwaydel).'</td><td align=\'right\'>'.number_format($cntreladel).'</td></tr>'."\n";
  echo '<tr><td>inserted</td><td align=\'right\'>'.number_format($cntnodeadd).'</td><td align=\'right\'>'.
       number_format($cntwayadd).'</td><td align=\'right\'>'.number_format($cntrelaadd).'</td></tr>'."\n";
  echo '</table>'."\n";
  echo '<br />'."\n";
  echo '<table><tr><th align=\'center\'>value</th><th>count</th></tr>'."\n";
  echo '<tr><td>inserted tag</td><td align=\'right\'>'.number_format($cnttag).'</td></tr>'."\n";
  echo '<tr><td>without check</td><td align=\'right\'>'.number_format($cntnocheck).'</td></tr>'."\n";
  echo '<tr><td>with check</td><td align=\'right\'>'.number_format($cntcheck).'</td></tr>'."\n";
  echo '<tr><td>failed checks</td><td align=\'right\'>'.number_format($cntfailed).'</td></tr>'."\n";
  echo '</table>'."\n";
  $mtime = explode(" ",microtime());
  $timeend = $mtime[1] + $mtime[0];
  $laufzeit = $timeend - $timebegin;
  echo '<br />'."\n";
  echo '<table><tr><th align=\'center\'>value</th><th>count</th></tr>'."\n";
  echo '<tr><td>lines of configfile</td><td align=\'right\'>'.number_format($cnt_conf_line).'</td></tr>'."\n";
  echo '<tr><td>number of total checks</td><td align=\'right\'>'.number_format($cnt_conf_size).'</td></tr>'."\n";
  echo '<tr><td>keywords with checks</td><td align=\'right\'>'.number_format($cnt_conf_noempty).'</td></tr>'."\n";
  echo '</table>'."\n";
  echo '<br />'."\n";
  echo '<table><tr><th align=\'center\'>value</th><th>count</th></tr>'."\n";
  echo '<tr><td>first time of change</td><td align=\'right\'>'.str_replace('Z',' ',str_replace('T',' ',$time_low)).
       '</td></tr>'."\n";
  echo '<tr><td>last time of change</td><td align=\'right\'>'.str_replace('Z',' ',str_replace('T',' ',$time_high)).
       '</td></tr>'."\n";
  echo '<tr><td>script runtime</td><td align=\'right\'>'.sprintf('%01.2f',$laufzeit).' second</td></tr>'."\n";
  echo '</table></p>'."\n";
  echo '</body></html>';
}

function register_object_node () {
  global $flg_insert;
  global $cntnodeadd;
  global $cntnodedel;
  if ($flg_insert) {
    $cntnodeadd++;
  } else {
    $cntnodedel++;
  }
}

function register_object_way () {
  global $flg_insert;
  global $cntwayadd;
  global $cntwaydel;
  if ($flg_insert) {
    $cntwayadd++;
  } else {
    $cntwaydel++;
  }
}

function register_object_relation () {
  global $flg_insert;
  global $cntrelaadd;
  global $cntreladel;
  if ($flg_insert) {
    $cntrelaadd++;
  } else {
    $cntreladel++;
  }
}

function register_time () {
  global $time_high;
  global $time_low;
  global $currtime;
  
  if ($currtime>$time_high) {
    $time_high=$currtime;
  }
  if ($currtime<$time_low) {
    $time_low=$currtime;
  }
}

function register_error_tag ($k, $v) {
  global $arrvalue;
  global $cntcheck;
  global $cntnocheck;
  global $currtyp;
  
  $returnvalue=true;
  switch ($arrvalue[$k]) { // e,f,m,s,
    case 'e': {
      $returnvalue=false;
      $cntnocheck++;
      break;
    }  // end of case 'e'
    case 's': {
      $cntcheck++;
      $check=-1;
      $check=$arrvalue[$k."#".$v];
      if ($check>1) {
        $returnvalue=false;
      } else {
        $returnvalue=notice_unused_info($k.' = '.$v);
      }
      $returnvalue=check_object_typ ($k, $v, $returnvalue);
      break; 
    }  // end of case 's'
    case 'f': {
      $cntcheck++;
      $check=-1;
      $returnvalue=check_number_unit ($k,$v);
      $returnvalue=check_object_typ ($k, $v, $returnvalue);
      break;
    } // end of case 'f'
    case 'm': {
      $cntcheck++;
      $check=-1;
      $check=$arrvalue[$k."#".$v];
      if ($check>1) {
        $returnvalue=false;
      } else {
        $returnvalue=check_number_unit ($k,$v);
      } 
      $returnvalue=check_object_typ($k,$v,$returnvalue);
      break;
    } // end of case 'm'
    default: {
      $cntcheck++;
      $returnvalue=notice_unused_info($k);
    } // end of default
  } // end of switch ($arrvalue[$k])
  return($returnvalue);
}

function check_number_unit ($k, $v) {
  // check the following typs
  // <number>
  // <numberUnitSpeed>      other units:  mph
  // <numberUnitDistance>   other units: km  ft
  //
  global $arrvalue;
  global $currtyp;
  
  $returnvalue=true;
  $check=$arrvalue[$k."#<number>"];
  if ($check>1) {
    if (is_numeric($v)) {
      $returnvalue=false;
    }
  } else {
    $check=$arrvalue[$k."#<numberUnitSpeed>"];
    if ($check>1) {
      $attrsv=trim(str_replace('mph','',$v)); 
      if (is_numeric($attrsv)) {
        $returnvalue=false;
      }
    } else {
      $check=$arrvalue[$k."#<numberUnitDistance>"];
      if ($check>1) {
        $attrsv=trim(str_replace('km','',$v));
        if (strlen($attrsv)==strlen($v)) {
          $attrsv=trim(str_replace('ft','',$v));
        }
        if (is_numeric($attrsv)) {
          $returnvalue=false;
        }
      }
    }
  }
  // return
  return ($returnvalue);
}      

function check_object_typ ($k, $v, $check) {
  // check on correct typ of the object
  global $arrvalue;
  global $currtyp;
  
  $returnvalue=$check;
  $strcheck=$k.'#'.$v.'#:type:';
  if (array_key_exists($strcheck, $arrvalue)) {
    if (strpos($arrvalue[$strcheck], $currtyp)===false) {
      $currtyp.='?';
      $returnvalue=true;
    }
  }
  // return
  return ($returnvalue);
}      

function notice_unused_info ($tag) {
  global $arrunused;
  global $max_arrunused;
  
  $returnvalue=true;
  if (array_key_exists($tag,$arrunused)) {
    $arrunused[$tag]++;
    if ($arrunused[$tag]>10) {
      $returnvalue=false;
    }
  } else {
    if (count($arrunused)<$max_arrunused) {
      $arrunused[$tag]=1;
    }
  }
  return($returnvalue);
}

function print_error ($k, $v) {
  global $cntfailed;
  global $currtyp;
  global $currid;
  global $currversion;
  global $confmailaddress;
  global $confmailsubject;
  
  $cntfailed++;
  if (OUTPUTTYP=='TEXT') {
    echo $currtyp.' '.$currid.' '.$currversion.': '.$k.' = '.$v."\n";
  } else {
    switch (substr($currtyp,0,1)) {
      case 'N': { $outimg='<img alt=\'Node\' src=\'./Mf_node.png\' />';
                  $outtyp='/node/';
                  $outjosmflag='';
                  break;
                }
      case 'W': { $outimg='<img alt=\'Way\' src=\'./Mf_way.png\' />';
                  $outtyp='/way/';                          
                  $outjosmflag='/full';
                  break;
                }
      case 'R': { $outimg='<img alt=\'Relation\' src=\'./Mf_relation.png\' />';
                  $outtyp='/relation/';
                  $outjosmflag='/full';
                  break;
                }
      default : { $outimg=$currtyp;
                  $outtyp='/';
                  $outjosmflag='';
				}
    }
    if (substr($currtyp,1,1)=='?') {
      $outimg .='<img alt=\'error\' title=\'wrong typ assumedly\'  src=\'./logoerror.png\' />';
    }
    echo '<tr><td>',$outimg,'</td><td align=\'right\'><a href=\'http://www.openstreetmap.org/browse',$outtyp,
         $currid,'\' target=\'_blank\'>',$currid,'</a></td><td align=\'center\'>',$currversion,'</td><td>',
         htmlentities($k,ENT_QUOTES,'UTF-8'),'</td><td>',htmlentities($v,ENT_QUOTES,'UTF-8'),
         '</td><td><a href=\'http://localhost:8111/import?url=http://api.openstreetmap.org/api/0.6',$outtyp,$currid,
         $outjosmflag,'\' target=\'hJOSM\'><img src=\'logojosm.png\' alt=\'josm\' title=\'josm\' border=\'0\'/></a>',
         '<a href=\'mailto:',$confmailaddress,'?subject=',$confmailsubject,'&amp;body=Object:%20',$outtyp,$currid,
         '\'><img src=\'./logoemail.png\' alt=\'mail\' title=\'mail\' border=\'0\' /></a></td></tr>',"\n";
  }
}

function analyse_xml ($data){
  global $currid;
  global $currtype;
  global $currversion;
  global $currtime;
  global $lat;
  global $long;
  
  $attrs=explode('"',$data,27);
  for ($i=0;$i<count($attrs);$i=$i+2) {
    $content=trim($attrs[$i]);
	switch ($content) {
	  case "<node id=":
	  case "<way id=":
	  case "<relation id=": {
		$currid=$attrs[$i+1];
		break;
	  }
	  case "lat=": {
		$lat=$attrs[$i+1];
	    break;
      }
	  case "lon=": {
		$lon=$attrs[$i+1];
		break;
      }
      case "version=": {
	    $currversion=$attrs[$i+1];
		break;
      }
      case "timestamp=": {
		$currtime=$attrs[$i+1];
        break;
	  }
	}
  }
}