<?php header("Content-Type: text/html; charset=UTF-8", true); ?>
<!--
  // Datei     : grafikOGDB.php
  // Version   : 0.4
  // History   : 0.4 20060421 Georg Verweyen Zweite Anzeigeform
  //             0.3 20060418 Georg Verweyen Performance: Vorgefertige 
  //                                         Landkarte nutzen
  /              0.2 20060417 Georg Verweyen Landkarte auf DB malen
  //             0.1 20060409 Georg Verweyen Creation
  // Author    : Georg Verweyen
  //             georg@familieverweyen.de
  // Needed    : conc.inc.php
  //             infoOGDB.php
  //             karte_001.jpg 
  //             Verzeichnis ./pics im Webserver-Dokumentenverzeichnis
  //
  // In der Datei conc.inc.php sind die Verbindungsdaten zur 
  // MySQL-Datenbank eingetragen
  // Minimalform also
  // < ? php 
  //   $server="ssss";
  //   $user="uuuu";
  //   $pass="pppp";
  //   $dbase="dddd";
  //   $conn =  mysql_connect($server, $user, $pass);
  //   if($conn) {
  //     mysql_select_db($dbase, $conn);
  //   }
  // ? >  // Blank zwischen beiden Zeichen ist zu entfernen
  //
  // Aus der Datei infoOGDB.php wird grafikOGDB.php mit den
  // korrekten Parametern aufgerufen.
  // 
  // Die Karte (File: karte_001.jpg) muss ins gleiche Verzeichnis
  // (änderbar, eingestellt ist ./pics) kopiert werden, in dem auch 
  // die temporären PHP-Scripte erzeugt werden.
  //
  // Im Verzeichnis ./pics werden Dateien mit dem Namen 
  // tmp_geodb_<objekt>.php angelegt.
-->
<html>
<head>
<title>Kontrollkarte</title>
</head>
<body>
<?php
  include("conn.inc.php");
  // Änderung zu Version 0.3 utf-8 Support
  mysql_query("set names 'utf8';");
  if (isset($_GET["id"]))
  {
    $qid=$_GET["id"];
  }
  else
  {
    $qid=0;
  }
  if (isset($_GET["val"]))
  {
    $qval=$_GET["val"];
  }
  else
  {
    $qval="";
  }
  // Anfang: Karteninformation und Konfiguration

  define(clonfaktor , 30);
  define(clonstart  ,  2);
  define(clonend    , 18);
  define(clonrand   ,  0);
  define(clatfaktor , 45);
  define(clatstart  , 45);
  define(clatend    , 56);
  define(clatrand   ,  1);
  define(ckartename , "karte_001.jpg");
  define(ckarteloc  , "pics");
  define(ctableinfo , false); // Zusätzliche Datentabelle ?
  define(cmarkloc   , true);  // Punkte markieren ?
  define(cshowkoord , true);  // Koordinatenkreuz anzeigen ?
  /*
  define(clonfaktor , 60);
  define(clonstart  ,  2.0);
  define(clonend    ,  8.0);
  define(clonrand   ,  0);
  define(clatfaktor , 90);
  define(clatstart  , 49);
  define(clatend    , 54);
  define(clatrand   ,  1);
  define(ckartename , "karte_002.jpg");
  define(ckarteloc  , "pics");
  define(ctableinfo , true ); // Zusätzliche Datentabelle ?
  define(cmarkloc   , true);  // Punkte markieren ?
  define(cshowkoord , true );  // Koordinatenkreuz anzeigen ?
  */
  // Ende: Karteninformation und Konfiguration

  //echo "ID: " . $qid . "<br />" . "Text: " . $qval;
  $sql   ="";
  if ($qid > 0)
  {
    $sql = $sql . "SELECT lon, lat" 
                . "  FROM geodb_coordinates,"
                . "       geodb_textdata"
                . " WHERE geodb_textdata.loc_id    = geodb_coordinates.loc_id"
                . "   AND geodb_textdata.text_val  = '".$qval . "' "
                . "   AND geodb_textdata.text_type = ".$qid
                . "   AND lon >= " . clonstart
                . "   AND lon <= " . clonend
                . "   AND lat >= " . clatstart
                . "   AND lat <= " . clatend
           ;
  }
  else
  {
    $sql = $sql . "SELECT lon, lat" 
                . "  FROM geodb_coordinates,"
                . "       geodb_hierarchies"
                . " WHERE geodb_coordinates.loc_id    = geodb_hierarchies.loc_id"
                . "   AND geodb_hierarchies.id_lvl" . (- $qid) .  " = " . $qval
                . "   AND lon >= " . clonstart
                . "   AND lon <= " . clonend
                . "   AND lat >= " . clatstart
                . "   AND lat <= " . clatend
           ;
  }
  $result=mysql_query($sql, $conn);
  $num   =mysql_num_rows($result);
  // Zur Kontrolle der Daten kann auch eine Tabelle ausgegeben werden
  if (($num > 0) && ctableinfo) // true, wenn Ausgabe gewünscht
  {
    echo "<table border='1'>";
    for ($i=0; $i<$num; $i++)
    {
      $qlon            =mysql_result($result, $i, "lon");
      $qlat            =mysql_result($result, $i, "lat");
      echo "<tr>" .
           "<td>" . $qlon             . "</td>" .
           "<td>" . $qlat             . "</td>" .
           "</tr>"
           ;
    }
    echo"</table><hr />";
  }
// Experimentell

  // Bildgröße berechnet
  $qxsize  = (clonend - clonstart) * clonfaktor + 1;
  $qxrsize = $qxsize + clonrand;
  $qysize  = (clatend - clatstart) * clatfaktor + 1;
  $qyrsize = $qysize + clatrand;
  // php-bilddatei erstellen
  $img=fopen(ckarteloc . "/tmp_geodb_$qval.php","w+");
  fputs($img,"<?php\n");
  fputs($img,"if (file_exists(\"" . ckartename . "\"))\n");
  fputs($img,"{\n");
  fputs($img,"\$b=ImageCreateFromJpeg(\"" . ckartename . "\");\n");
  fputs($img,"\$c0=Imagecolorallocate(\$b,255,  0,  0);\n"); // rot für Markierungen
  fputs($img,"\$c1=Imagecolorallocate(\$b,  0,  0,  0);\n"); // schwarz für Landesgrenzen
  fputs($img,"\$c2=Imagecolorallocate(\$b,128,128,128);\n"); // grau für Verwaltungsgrenzen
  fputs($img,"\$c3=Imagecolorallocate(\$b,  0,  0,255);\n"); // blau für Zahlen
  fputs($img,"\$c4=Imagecolorallocate(\$b,  0,255,  0);\n"); // grün für Koordinatenkreuz
  // Hinweis:
  //   folgende Routinen sind nicht zwingend für 
  //   funktionieren notwendig und können auf eigene 
  //   Gefahr gelöscht bzw. modifiziert werden.
  //   Beachten Sie auch die Möglichkeit der
  //   Konfiguration durch die Konstanten.
  // Koordinaten einzeichnen
  if (($num > 0) && cmarkloc)
  {
    for ($i=0; $i<$num; $i++)
    {
      $qlon = mysql_result($result, $i, "lon");
      $qlat = mysql_result($result, $i, "lat");
      $qx   = ceil(($qlon - clonstart) * clonfaktor);
      $qy   = $qysize-ceil(($qlat - clatstart) * clatfaktor);
      // Zeichne roten Kreis mit 3 Punkten Radius
      fputs($img,"\nimagearc(\$b,$qx,$qy,3,3,1,360,\$c0);");
    }
  }
  // Koordinatennetz zeichen
  if (cshowkoord)
  {
    for ($i=clonstart; $i<=clonend; $i++)
    {
      $qx = ($i-clonstart)*clonfaktor;
      fputs($img,"\nimageLine(\$b,$qx,0,$qx,$qysize,\$c4);");
    }
    for ($i=clatstart; $i<=clatend; $i++)
    {
      $qy = $qysize - ($i-clatstart)*clatfaktor;
      fputs($img,"\nimageLine(\$b,0,$qy,$qxsize,$qy,\$c4);");
    }
    // Latidude in 3° Schritten in Farbe blau 
    for ($i=clatstart; $i<=clatend; $i=$i+3)
    {
      $qy = $qysize - ($i-clatstart)*clatfaktor;
      fputs($img,"\nimageString(\$b,5,0,($qy-15),\"$i\",\$c3);");
    }
  } // Ende Koordinatennetz
  // Anfang: Ab hier neue Daten schreiben
  // Ende: Bis hier neue Daten schreiben
  // Fehlerbehandlung bei nicht vorhandener Karte
  fputs($img,"\n}\nelse {\n");
  fputs($img,"\$b = ImageCreate (150, 30);\n");
  fputs($img,"\$bgc = ImageColorAllocate (\$b, 255, 255, 255);\n");
  fputs($img,"\$tc  = ImageColorAllocate (\$b, 0, 0, 0);\n");
  fputs($img,"ImageFilledRectangle (\$b, 0, 0, 150, 30, \$bgc);\n");
  fputs($img,"ImageString(\$b, 1, 5, 5, \"Fehler beim Oeffnen der Karte!\", \$tc);\n");
  fputs($img,"}\n");
  // Header schreiben
  fputs($img,"\nheader(\"Content-type:image/jpeg\");");
  fputs($img,"\nImagejpeg(\$b);");
  fputs($img,"\n?>");
  // Datei schließen
  fclose($img);

  //Bild anzeigen
  echo "<img src=\"". ckarteloc . "/tmp_geodb_$qval.php\"><br />"; 
  if ($qid < 0)
  {
    $sql   ="";
    $sql   =$sql . "SELECT text_val" 
                 . "  FROM geodb_textdata"
                 . " WHERE loc_id=" . $qval
                 . " ORDER BY text_type, text_locale, valid_until, text_val"
            ;
    $result=mysql_query($sql, $conn);
    $num   =mysql_num_rows($result);
    if ($num > 0)
    {
      $qtext_val = mysql_result($result, 0, "text_val");
      echo ("Objekt: $qtext_val");
    }
  }
  else
  {
    echo ("Autokennzeichen: $qval");
  }
  //

// Ende des Scriptes grafikOGDB.php

?>
</body>
</html> 
