<?php header("Content-Type: text/html; charset=UTF-8", true); 
  /*
  // Datei     : infoOGDB.php
  // Version   : 0.9
  // History   :
  //             0.9 20120330 Georg Verweyen Tippfehler bzgl Includedatei entfernt, PHP Konstrukte angepasst, 
  //                                         Tabellen-Klartext ersetzt
  //             0.8 20071001 Georg Verweyen Verifikation 0.2.5.1, Prüfung auf DB-Datenbankverbindung
  //             0.7 20060507 Georg Verweyen Neues Datumsformat, 
  //                                         Fehlerkorrektur geodb_hierarchies (neue
  //                                         Ausgabe)
  //             0.6 20060427 Georg Verweyen Alternativ nativ statt deutschen
  //                                         Eintrag suchen
  //             0.5 20060420 Georg Verweyen Implementierung einer Suche 
  //             0.4 20060409 Georg Verweyen Grafische Kontrolle
  //             0.3 20060402 Georg Verweyen UTF-8 Support
  //             0.2 20060325 Georg Verweyen added INTDATA & FLOATDATA, 
  //                                         Interpretation von Werten
  //             0.1 20060320 Georg Verweyen Creation
  // Author    : Georg Verweyen
  //             georg@familieverweyen.de
  // Needed    : conn.inc.php       // modified 0.9
  //             grafikOGDB.php
  //
  // In der Datei conn.inc.php sind die Verbindungsdaten zur 
  // MySQL-Datenbank eingetragen
  // Minimalform also
  // < ? php   // Blank zwischen beiden Zeichen ? und > ist zu entfernen
  //   $server="ssss";
  //   $user="uuuu";
  //   $pass="pppp";
  //   $dbase="dddd";
  //   $conn =  mysql_connect($server, $user, $pass);
  //   if($conn) {
  //     mysql_select_db($dbase, $conn);
  //   }
  // ? >  // Blank zwischen beiden Zeichen ? und > ist zu entfernen
  //
  // Die Datei grafikOGDB.php wird zum Zeichen der Bilder aufgerufen.
  // Derzeit wird ein Verzeichnis ./pics erwartet, in dem fuer jedes
  // Objekt (derzeit Autokennzeichen) eine Datei erzeugt wird.
  */
?>
<html>
<head><title>infoOpenGeoDB</title></head>
<body>
<?php
  // Ende Konstantenvereinbarung
  define("cIDonly"   , 100);
  define("cTitel"    , 110);
  define("cText"     , 120);
  define("cDBConnect", "./conn.inc.php");
  $arr_tables = array ('geodb_locations',  'geodb_hierarchies',
                       'geodb_coordinates','geodb_textdata',
                       'geodb_intdata',    'geodb_floatdata',
                       'geodb_type_names')
                ;
  $dbversion="0.2.5";
  // Ende Konstantenvereinbarung
  if (file_exists(cDBConnect)) { // Änderung zu Version 0.8 Prüfung, ob conn.inc.php (bzw. cDBConnect) existiert
    include(cDBConnect);
  } else {
    echo "<b>Installationshinweis:</b> Die Datei ".cDBConnect.", mit den Informationen zur Datenbankverbindung, fehlt noch!<br /><br />";
    echo "Die Verarbeitung wird eingestellt!";
    die ('Sorry');
  }
  // Änderung zu Version 0.3 utf-8 Support
  mysql_query("set names 'utf8';");
  // Wenn kein Parameter übergeben wird, wird als
  // Default 104 Europa übergeben.
  if (isset($_GET["loc_id"]))
  {
    $loc_id=$_GET["loc_id"];
    $search="";
  }
  elseif (isset($_GET["search"]))
  {
    $search=$_GET["search"];
    $loc_id=0;
    if ($search=="") {$search='gve';}
  }
  else
  {
    $loc_id=104; // Europa = 104
  }
  if ($search != "") 
  {
    echo "<h1>Suchergebnis</h1>\n";
    $search = htmlspecialchars($search, ENT_QUOTES);
    $sql   = "";
    $sql   = $sql . "SELECT DISTINCT loc_id" 
                  . "  FROM " .$arr_tables[3] 
                  . " WHERE text_val like '%" . $search . "%'";
            ;
    //echo $sql;
    $result=mysql_query($sql, $conn);
    $num   =mysql_num_rows($result);
    for ($i=0; $i<$num; $i++)
    {
      $qloc_id =mysql_result($result, $i, "loc_id");
      echo trans_object ($qloc_id, cText) . "<br />\n";
    }
    echo "<hr /><p><i>Wenn das passende nicht dabei sein sollte, " . 
         "können Sie es hier erneut versuchen:</i><br /></p>";
    subform_search();
  } // Ende pos. Zweig der Abfrage Übergabevariable search gesetzt
  else
  {
    echo "<table><tr><td>Suche nach </td><td>";
    subform_search();
    echo "</td></tr></table><hr />\n";
    echo "<h1>Infoblatt zum Objekt ". $loc_id . "</h1>";
    echo "<p><i>Version 0.9</i><br></p>";
    $anzahl = count($arr_tables);
    // Anzahl der Datensätze
    echo "<table border='1'><tr><th>Tabelle</th><th>Anzahl</th></tr>";
    for ($i = 0; $i < $anzahl; $i++) 
    {
      $sql   ="";
      $sql   =$sql . "SELECT count(*) as anzahl FROM "  
                   . $arr_tables[$i] . " WHERE loc_id=" 
                   . $loc_id
              ;
      $result=mysql_query($sql, $conn);
      $num   =mysql_num_rows($result);
      // Es wird genau 1 Datensatz erwartet
      $anz   =mysql_result($result, 0, "anzahl");
      echo "<tr><td>";
      if ($anz>0) echo "<a href='#". $i ."'>";
      echo $arr_tables[$i];
      if ($anz>0) {
        echo "</a>";
        echo "</td><td align='right'>". $anz . "</td></tr>";
      } else {
        echo '</td><td>&nbsp;</td></tr>';
        if (($i==1) && ($anz==0)) {
          $dbversion="0.2.5";
        }
      }
    }
    echo "</table><hr />";
    //
    // Interpretation von GEODB_LOCATION
    //
    $sql   ="";
    $sql   =$sql . 'SELECT '.$arr_tables[6] .'.type_locale,'
                 . '       '.$arr_tables[6] .'.name'
                 . '  FROM ' .$arr_tables[0] . ', ' 
                 .            $arr_tables[6]  
                 . ' WHERE ' .$arr_tables[0] . '.loc_id=' . $loc_id
                 . '   AND ' .$arr_tables[0] . '.loc_type = '.$arr_tables[6] .'.type_id'
            ;
    $result=mysql_query($sql, $conn);
    $num   =mysql_num_rows($result);
    if ($num > 0) 
    {
      echo "<a name='0'></a><b>" .$arr_tables[0] . "</b>: <br />";
      echo "<table>";
      for ($i=0; $i<$num; $i++)
      {
        $qname =mysql_result($result, $i, "name");
        $qlocale=mysql_result($result, $i, "type_locale");
        echo "<tr><td>" .$qname . "</td><td>" . trans_locale($qlocale) . "</td>";
        echo "</tr>";
      }
      echo"</table><hr />";
    }
    //
    // Interpretation von GEODB_HIERARCHIES
    //
    if ($dbversion=="0.2.4") {
    $sql   ="";
    $sql   =$sql . "SELECT *" 
                 . "  FROM " .$arr_tables[1]
                 . " WHERE loc_id=" . $loc_id
                 . " ORDER BY valid_until"
            ;
    $result=mysql_query($sql, $conn);
    $num   =mysql_num_rows($result);
    if ($num > 0) 
    { // theoretisch sollte $num==1 sein.
      echo "\n<a name='1'></a><b>" .$arr_tables[1] . ":</b>";
      $qlevel =mysql_result($result, 0, "level"); // In der Hoffnung, dass die Theorie gegeben ist.
      echo ("<td rowspan='$num'>&nbsp;&nbsp;&nbsp;&nbsp;" . 
            "<a href='grafikOGDB.php?id=-$qlevel&val=$loc_id' " .
            "target=\"pic\">Grafik anzeigen</a></td>")
      ;
    }

      echo "<br /><table border='1'>";
      for ($i=0; $i<$num; $i++)
      { // Neu zu 0.5 qid_lvl1..9 wurden in ein Array qid_lvl verwandelt
        $qlevel          =mysql_result($result, $i, "level");
        $qid_lvl[1]      =mysql_result($result, $i, "id_lvl1");
        $qid_lvl[2]      =mysql_result($result, $i, "id_lvl2");
        $qid_lvl[3]      =mysql_result($result, $i, "id_lvl3");
        $qid_lvl[4]      =mysql_result($result, $i, "id_lvl4");
        $qid_lvl[5]      =mysql_result($result, $i, "id_lvl5");
        $qid_lvl[6]      =mysql_result($result, $i, "id_lvl6");
        $qid_lvl[7]      =mysql_result($result, $i, "id_lvl7");
        $qid_lvl[8]      =mysql_result($result, $i, "id_lvl8");
        $qid_lvl[9]      =mysql_result($result, $i, "id_lvl9");
        $qvalid_since    =mysql_result($result, $i, "valid_since");
        $qdate_type_since=mysql_result($result, $i, "date_type_since");
        $qvalid_until    =mysql_result($result, $i, "valid_until");
        $qdate_type_until=mysql_result($result, $i, "date_type_until");
        // Wahl der Ausgabeformat
        // true  zeigt in mehrzeilige Tabelle an (neu zu Version 0.5)
        // false zeigt in einzeilige Version an (Standard bis Version 0.5)
        if (false) // Ausgabeformat
        {
          if ($i==0) {  // Änderung in Version 0.7 nur einmalige Ausgabe
            echo "<tr><td>Level</td>" .
                 "<td colspan='9' align='center'>Level 1..9</td>" .
                 "<td colspan='2'>g&uuml;ltig von</td>" .
                 "<td colspan='2'>g&uuml;ltig bis</td></tr>"
            ;
          }
          echo "\n<tr>" .
               "<td align='right'>" . $qlevel . "</td>" .
               "<td>". trans_object ($qid_lvl[1], cText) ."</td>" .
               "<td>". trans_object ($qid_lvl[2], cText) ."</td>" .
               "<td>". trans_object ($qid_lvl[3], cText) ."</td>" .
               "<td>". trans_object ($qid_lvl[4], cText) ."</td>" .
               "<td>". trans_object ($qid_lvl[5], cText) ."</td>" .
               "<td>". trans_object ($qid_lvl[6], cText) ."</td>" .
               "<td>". trans_object ($qid_lvl[7], cText) ."</td>" .
               "<td>". trans_object ($qid_lvl[8], cText) ."</td>" .
               "<td>". trans_object ($qid_lvl[9], cText) ."</td>" .
               trans_date ($qvalid_since, $qdate_type_since, $qvalid_until, $qdate_type_until) .
               "</tr>"
          ;
        }
        else { // ersetze "$qlevel+1" mit 10
          if ($i==0) {
            echo "<tr><td>Level</td>" .
                 "<td colspan='".(10)."' align='center'>Wert</td>" .
                 "<td colspan='2'>g&uuml;ltig von</td>" .
                 "<td colspan='2'>g&uuml;ltig bis</td></tr>"
            ;
          }
          for ($j=1; $j<=$qlevel;$j++)
          {
            echo "<tr>";
            if ($j==1)
            {
              echo "\n<td rowspan='$qlevel' align='right'> $qlevel</td>";
              echo "<td colspan='".(10)."'>". trans_object ($qid_lvl[1], cText) . "</td>";
              echo trans_date ($qvalid_since, $qdate_type_since, $qvalid_until, 
                               $qdate_type_until, $qlevel)
              ;
            } else {
              echo "\n<td colspan='".$j."' width='" . ($j*7) . "%'><hr /></td>";
              if ($j < $qlevel+1) {
                echo "\n<td colspan='".(10-$j)."'>" . 
                     trans_object($qid_lvl[$j],cText) . 
                     "</td>"
                ;
              }
            }
            echo "</tr>";
          }
        }
      }
      echo"</table><hr />";
    } else { // Version 0.2.5
      $qvalue=$loc_id;
      unset ($qid_lvl);
      $qlevel_max=-1;
      while ($qvalue<>-1) { 
        //echo $qvalue . " -- "; print_r($qid_lvl);  echo " <br />";
        $sql   ="";
        $sql   =$sql . "SELECT *" 
                     . "  FROM " . $arr_tables[3]
                     . " WHERE loc_id=" . $qvalue
                     . "   AND (text_type=400200000" /* Level feststellen */
                     . "    OR  text_type=400100000" /* Vorgänger feststellen */
                     . "       )"
                     . " ORDER BY text_type, text_locale, valid_until, text_val"
                ;
        $result=mysql_query($sql, $conn);
        $num   =mysql_num_rows($result);
        $save   = $qvalue;
        $qlevel = -1;
        $qvalue = -1;
        if ($num > 0) { // 2 Werte erwartet
	  for ($i=0; $i<$num; $i++){
            //$qloc_id       =mysql_result($result, $i, "loc_id");
            $qtext_val       =mysql_result($result, $i, "text_val");
            $qtext_type      =mysql_result($result, $i, "text_type");
            $qtext_locale    =mysql_result($result, $i, "text_locale");
            $qis_native_lang =mysql_result($result, $i, "is_native_lang");
            $qis_default_name=mysql_result($result, $i, "is_default_name");
            $qvalid_since    =mysql_result($result, $i, "valid_since");
            $qdate_type_since=mysql_result($result, $i, "date_type_since");
            $qvalid_until    =mysql_result($result, $i, "valid_until");
            $qdate_type_until=mysql_result($result, $i, "date_type_until");
	    if ($qtext_type==400200000) {
	      $qlevel=$qtext_val; 
	      if ($qlevel_max==-1) {
	        $qlevel_max=$qtext_val;
	      }
	    }
	    if ($qtext_type==400100000) {$qvalue=$qtext_val; }
          }
          $qid_lvl[$qlevel]=$save;
          $qid_lvl[$qlevel-1]=$qvalue;
          $qlevel=$qlevel_max;
        }
      }
      echo "<table border='1'>";
      for ($i=0; $i <= count($qid_lvl)-1; $i++) {
        if ($i==0) {
          echo "<tr><td>Level</td>" .
               "<td colspan='".(count($qid_lvl)+1)."' align='center'>Wert</td>" .
               "<td colspan='2'>g&uuml;ltig von</td>" .
               "<td colspan='2'>g&uuml;ltig bis</td></tr>"
          ;
        } else {
          if ($i==1) {
            echo "\n<td rowspan='".(count($qid_lvl)-1)."' align='right'>".(count($qid_lvl)-1)."</td>";
            echo "<td colspan='".(count($qid_lvl)+1)."'>". trans_object ($qid_lvl[$i], cText) . "</td>";
            echo trans_date ($qvalid_since, $qdate_type_since, $qvalid_until, 
                             $qdate_type_until, count($qid_lvl))
            ;
          } else {
            echo "\n<td colspan='".$i."' width='" . ($i*7) . "%'><hr /></td>";
            if ($j < $qlevel) {
              echo "\n<td colspan='".(count($qid_lvl)+1-$i)."'>" . 
                   trans_object($qid_lvl[$i],cText) . 
                   "</td>"
              ;
            }
          }
        }
        echo "<tr>\n";
      }
      echo"</table><hr />";
    }
    //
    // Interpretation von GEODB_COORDINATES
    //
    $sql   ="";
    $sql   =$sql . "SELECT *" 
                 . "  FROM " . $arr_tables[2]
                 . " WHERE loc_id=" . $loc_id
            ;
    $result=mysql_query($sql, $conn);
    $num   =mysql_num_rows($result);
    if ($num > 0) 
    {
      echo "\n<a name='2'></a><b>" .$arr_tables[2] . "</b><br><table border='1'>";
      for ($i=0; $i<$num; $i++)
      {
        //$qloc_id         =mysql_result($result, $i, "loc_id");
        $qlon            =mysql_result($result, $i, "lon");
        $qlat            =mysql_result($result, $i, "lat");
        $qcoord_type     =mysql_result($result, $i, "coord_type");
        $qvalid_since    =mysql_result($result, $i, "valid_since");
        $qdate_type_since=mysql_result($result, $i, "date_type_since");
        $qvalid_until    =mysql_result($result, $i, "valid_until");
        $qdate_type_until=mysql_result($result, $i, "date_type_until");
        echo "<tr>" .
             "<td>" . $qlon             . "</td>" .
             "<td>" . $qlat             . "</td>" .
             "<td>" . trans_type($qcoord_type) . "</td>" .
             trans_date ($qvalid_since, $qdate_type_since, $qvalid_until, $qdate_type_until) .
             "</tr>"
             ;
      }
      echo"</table><hr />";
    }
    //
    // Interpretation von GEODB_TEXTDATA
    //
    $sql   ="";
    $sql   =$sql . "SELECT *" 
                 . "  FROM " . $arr_tables[3]
                 . " WHERE loc_id=" . $loc_id
                 . " ORDER BY text_type, text_locale, valid_until, text_val"
            ;
    $result=mysql_query($sql, $conn);
    $num   =mysql_num_rows($result);
    if ($num > 0) 
    { echo "\n<a name='3'></a><b>" . $arr_tables[3] . ":</b><br><table border='1'>";
      echo "\n<tr><th>Typ</td>" .
           "<th>Text</th>" .
           "<th>&nbsp;</th>" .
           "<th>Native</th>" .
           "<th>Default</th>" .
           "<th colspan='2'>g&uuml;ltig von</th>" .
           "<th colspan='2'>g&uuml;ltig bis</th></tr>";
      for ($i=0; $i<$num; $i++)
      {
        //$qloc_id         =mysql_result($result, $i, "loc_id");
        $qtext_val       =mysql_result($result, $i, "text_val");
        $qtext_type      =mysql_result($result, $i, "text_type");
        $qtext_locale    =mysql_result($result, $i, "text_locale");
        $qis_native_lang =mysql_result($result, $i, "is_native_lang");
        $qis_default_name=mysql_result($result, $i, "is_default_name");
        $qvalid_since    =mysql_result($result, $i, "valid_since");
        $qdate_type_since=mysql_result($result, $i, "date_type_since");
        $qvalid_until    =mysql_result($result, $i, "valid_until");
        $qdate_type_until=mysql_result($result, $i, "date_type_until");
        echo "\n<tr>" .
             "<td>";
        if (($qtext_type==500500000) && ($qlevel > 2)) {// Autokennzeichen 
          echo "<a href='grafikOGDB.php?id=500500000&val=" . 
               $qtext_val . "' target=\"pic\">" . trans_type($qtext_type) . 
               "</a>";
        }
        else
        {
          echo trans_type($qtext_type);
        }
        echo "</td>" .
             "<td>" . $qtext_val . "</td>" .
             "<td>" . trans_locale($qtext_locale)  . "</td>" .
             "<td align='center'>" . $qis_native_lang           . "</td>" .
             "<td align='center'>" . $qis_default_name          . "</td>" .
             trans_date ($qvalid_since, $qdate_type_since, $qvalid_until, $qdate_type_until) .
             "</tr>"
             ;
      }
      echo"</table><hr />\n";
    }
    //
    // Interpretation von GEODB_INTDATA
    //
    // Änderung zu Version 0.8: Löschen des Feldes int_subtype
    $sql   ="";
    $sql   =$sql . "SELECT *" 
                 . "  FROM ". $arr_tables[4]
                 . " WHERE loc_id=" . $loc_id
                 . " ORDER BY int_type, valid_until"
//                 . " ORDER BY int_type, int_subtype, valid_until"
            ;
    $result=mysql_query($sql, $conn);
    $num   =mysql_num_rows($result);
    if ($num > 0) 
    {
      echo "<a name='4' /><b>" . $arr_tables[4] . ":</b><br><table border='1'>";
      echo "\n<tr><th>Typ</td>" . // modified 0.9
           "<th>Wert</th>" .
           "<th colspan='2'>g&uuml;ltig von</th>" .
           "<th colspan='2'>g&uuml;ltig bis</th></tr>";
      for ($i=0; $i<$num; $i++)
      {
        //$qloc_id         =mysql_result($result, $i, "loc_id");
        $qint_val        =mysql_result($result, $i, "int_val");
        $qint_type       =mysql_result($result, $i, "int_type");
//        $qint_subtype    =mysql_result($result, $i, "int_subtype");
        $qvalid_since    =mysql_result($result, $i, "valid_since");
        $qdate_type_since=mysql_result($result, $i, "date_type_since");
        $qvalid_until    =mysql_result($result, $i, "valid_until");
        $qdate_type_until=mysql_result($result, $i, "date_type_until");
        echo "<tr>" .
             "<td>" . trans_type($qint_type)     . "</td>" .
             /*"<td>" . trans_type($qint_subtype)  . "</td>" .*/
             "<td>" . $qint_val                  . "</td>" .
             trans_date ($qvalid_since, $qdate_type_since, $qvalid_until, $qdate_type_until) .
             "</tr>"
             ;
      }
      echo"</table><hr />\n";
    }
    //
    // Interpretation von GEODB_FLOATDATA
    //
    // Änderung zu Version 0.8: Löschen des Feldes float_subtype

    // Achtung: Ausgabe ungetestet da keine Daten vorhanden
    $sql   ="";
    $sql   =$sql . "SELECT *" 
                 . "  FROM " .$arr_tables[5]
                 . " WHERE loc_id=" . $loc_id
                 . " ORDER BY float_type, valid_until"
//                 . " ORDER BY float_type, float_subtype, valid_until"
            ;
    $result=mysql_query($sql, $conn);
    $num   =mysql_num_rows($result);
    if ($num > 0) 
    {
      echo "<a name='5' /><b>" .$arr_tables[5] . ":</b><br><table border='1'>";
      echo "\n<tr><th>Typ</td>" . // modified 0.9
           "<th>Wert</th>" .
           "<th colspan='2'>g&uuml;ltig von</th>" .
           "<th colspan='2'>g&uuml;ltig bis</th></tr>";
      for ($i=0; $i<$num; $i++)
      {
        $qloc_id         =mysql_result($result, $i, "loc_id");
        $qfloat_val      =mysql_result($result, $i, "float_val");
        $qfloat_type     =mysql_result($result, $i, "float_type");
        // $qfloat_subtype  =mysql_result($result, $i, "float_subtype");
        $qvalid_since    =mysql_result($result, $i, "valid_since");
        $qdate_type_since=mysql_result($result, $i, "date_type_since");
        $qvalid_until    =mysql_result($result, $i, "valid_until");
        $qdate_type_until=mysql_result($result, $i, "date_type_until");
        echo "<tr>" .
             //"<td>" . $qloc_id                   . "</td>" .
             "<td>" . trans_type($qfloat_type)   . "</td>" .
             "<td>" . $qfloat_val                . "</td>" .
             // "<td>" . $qfloat_subtype            . "</td>" .
             trans_date ($qvalid_since, $qdate_type_since, $qvalid_until, $qdate_type_until) .
             "</tr>"
             ;
      }
      echo"</table><hr />";
    }
    //
    // Folgeobjekte
    //
    if ($dbversion=="0.2.4") {
      $sql   ="";
      $sql   =$sql . "SELECT level"
                   . "  FROM " .$arr_tables[1] 
                   . " WHERE " .$arr_tables[1] . ".loc_id=" . $loc_id
              ;
      $result=mysql_query($sql, $conn);
      $num   =mysql_num_rows($result);
      if ($num > 0)  // Änderung Version 0.2 falls Objectid nicht existent
      {
        // Nur ein datensatz erwartet
        $qlevel=mysql_result($result, 0, "level");
        $sql   ="";
  /*    // SQL-Statement vor Version 0.7
        $sql   =$sql . "SELECT DISTINCT loc_id"
                     . "  FROM geodb_hierarchies" 
                     . " WHERE geodb_hierarchies.id_lvl" .$qlevel."=" . $loc_id
                     . "   AND geodb_hierarchies.id_lvl" .($qlevel+1)." is not null"
                     . "   AND geodb_hierarchies.id_lvl" .($qlevel+2)." is null"
                     . " ORDER BY loc_id"
                ;
  */
        echo "<b>Folgeobjekt(e):</b><br /> ";
        $count=1;
        while (show_folgeobject ($loc_id, $qlevel, $count)) {
          $count++;
        }
        echo "<i>-- Ende der Liste --</i><br /> ";
      }
    } else { // $dbversion=="0.2.5"
      $sql   ="";
      $sql   =$sql . "SELECT loc_id"
                   . "  FROM " .$arr_tables[3] 
                   . " WHERE " .$arr_tables[3] . ".text_val=" . $loc_id
                   . "   AND text_type=400100000"
              ;
      //echo $sql;
      $result=mysql_query($sql, $conn);
      $num   =mysql_num_rows($result);
      if ($num > 0)  
      {
        echo "<b>Folgeobjekt(e):</b><br /> ";
        for ($i=0; $i<$num; $i++){
          $qlevel=mysql_result($result, $i, "loc_id");
          echo trans_object ($qlevel, cText) . "<br />";
        }
      }
    }
} // Ende neg. Zweig der Abfrage Ü›bergabevariable search gesetzt
//----------------------------------------------
//--- Ende der Hauptroutine von infoOGDB.php ---
//----------------------------------------------
function subform_search ()
{
  echo ("<form action='" . $_SERVER['PHP_SELF'] . "' method='get' enctype='multipart/form-data'>");
  echo "<input type='text' name='search' size='30'>";
  echo "<input type='submit' value='Ok'></form>";
}
// Function trans_locale
//   Ersetzt die deutsche Spracheinstellung
//   (default für diese Datenbank) mit einem Blank
function trans_locale ($locale)
{
  if ($locale=="de" | $locale=="")
  {
    $locale="&nbsp;";
  }
  else
  {
    $locale=" Sprache: " . $locale;
  }
  return $locale;
}
// Function trans_object
//   Ausgabe einer Object-ID mit der Möglichkeit das
//   Script mit entsprechenden Parameter erneut zu starten
//
//   Änderung zu Version 0.5 
//   $flgwork bestimmt, ob der Text zum Objekt herausgesucht
//   wird und wie er präsentiert wird.
//   Ausprägungen:
//     cIDonly		kein Titel, Linktext ist die ID (Verhalten vor 0.5)
//     cTitel		Text als Titel vom Link, Linktext ist die ID
//     cText		Text als Linktext, ID als Titel vom Link
function trans_object ($idobj, $flgwork=cIDonly)
{
  global   $conn;
  global   $arr_tables;
  $qtext   = "";
  $qreturn = "";
  if (($flgwork <> cIDonly) && ($idobj>0))
  {
    /* // Abfragevarinate bis Version 0.5
    $sql = "";
    $sql = $sql . "SELECT text_val, loc_type ";
    $sql = $sql . "FROM geodb_textdata, " ;
    $sql = $sql . "     geodb_location " ;
    $sql = $sql . "WHERE geodb_textdata.loc_id = $idobj";
    $sql = $sql . "  AND geodb_textdata.loc_id = geodb_location.loc_id";
    $sql = $sql . "  AND text_type in (500100000)";
    $sql = $sql . "  AND ifnull(text_locale,\"de\")=\"de\"";
    */
    // modified 0.9 Tabellen-Namen aus Array übernommen.
    $sql = '';
    $sql = $sql . 'SELECT 1 as sortval, text_val, loc_type ';
    $sql = $sql . 'FROM ' .$arr_tables[3]. ', ' ;
    $sql = $sql . "     " .$arr_tables[0]. " " ;
    $sql = $sql . "WHERE " .$arr_tables[3]. ".loc_id = $idobj";
    $sql = $sql . "  AND " .$arr_tables[3]. ".loc_id = " .$arr_tables[0]. ".loc_id";
    $sql = $sql . "  AND text_type in (500100000)";
    $sql = $sql . "  AND ifnull(text_locale,\"de\")=\"de\" ";
    $sql = $sql . "UNION ";
    $sql = $sql . "SELECT 2, text_val, loc_type ";
    $sql = $sql . "FROM " .$arr_tables[3]. ", " ;
    $sql = $sql . "     " .$arr_tables[0]. " " ;
    $sql = $sql . "WHERE " .$arr_tables[3]. ".loc_id = $idobj";
    $sql = $sql . "  AND " .$arr_tables[3]. ".loc_id = " .$arr_tables[0]. ".loc_id";
    $sql = $sql . "  AND text_type in (500100000)";
    $sql = $sql . "  AND is_native_lang = true ";
    $sql = $sql . "  AND is_default_name = true ";
    $sql = $sql . "UNION ";
    $sql = $sql . "SELECT 3, text_val, loc_type ";
    $sql = $sql . "FROM " .$arr_tables[3]. ", " ;
    $sql = $sql . "     " .$arr_tables[0]. " " ;
    $sql = $sql . "WHERE " .$arr_tables[3]. ".loc_id = $idobj";
    $sql = $sql . "  AND " .$arr_tables[3]. ".loc_id = " .$arr_tables[0]. ".loc_id";
    $sql = $sql . "  AND text_type in (500100000)";
    $sql = $sql . "  AND is_native_lang = true ";
    $sql = $sql . "  AND is_default_name = false ";
    $sql = $sql . "ORDER BY sortval";
    $result=mysql_query($sql, $conn);
    $num   =mysql_num_rows($result);
    //echo ("$num : $sql <br />\n"); // DebugInfo
    if ($num > 0)
    {
      // Nur ein datensatz erwartet
      $qtext= mysql_result($result, 0, "text_val");
      $qloc = mysql_result($result, 0, "loc_type");
    }
    if ($qloc == 100800000) // Postleitzahlgebiet
    {
      $qtext = "PLZ-Gebiet $qtext";
    }
  }
  if ($idobj>0)
  {
    $qreturn1 = "<a href='" . $_SERVER['PHP_SELF'] . "?loc_id=" . $idobj . "'";
    if ($flgwork == cIDonly)
    {
       $qreturn = $qreturn1 . ">$idobj</a>";
    }
    elseif ($flgwork == cTitel)
    {
       $qreturn = $qreturn1 . " title=\"$qtext\">$idobj</a>";
    }
    else
    {
       $qreturn = $qreturn1 . " title=\"loc_id=$idobj\">$qtext</a>";
    }
  }
  else
  {
    $qreturn = "&nbsp;";
  }
  return $qreturn;
}
// function trans_date
//   Übersetzt die 4 Attribute, die einen Zeitraum bestimmen, in 
//   umgangsprachliche Ausdrücke und gibt diese auch mit HTML-
//   Formatierungen (wegen möglichen ColSpan) aus.
//
//   Änderung zu Version 0.5 
//   $anzrows gibt an über wieviele Zeilen die Information sich erstreckt
//   Änderung zu Version 0.7
//   Neue Formatierung bei since=NULL und until mit festen Datum
function trans_date ($date_since, $type_since, $date_until, $type_until, $anzrow=1)
{
  $qcol4   = "<td colspan='4' align='center' ";
  $qcol2   = "<td colspan='2' align='center' ";
  $qcol1   = "<td align='center' ";
  $qrow    = ">";
  $qend    = "</td>";
  $qreturn = "";
  if ($anzrow > 1) 
  {
     $qrow = "rowspan='$anzrow'>";
  }
  //
  if (($type_since == '') && ($type_until == 300500000))
  {
    $qreturn=$qcol4 . $qrow . "- immer -" . $qend;
  }
  else if (($type_since == '') && ($type_until == 300100000))
  { // Neu zu Version 0.7
    $qreturn=$qcol2 . $qrow . "&nbsp;" . $qend .
             $qcol2 . $qrow . "bis " . format_date ($date_until) . $qend
    ;
  }
  else if (($type_since == 300300000) && ($type_until == 300300000))
  {
    $qreturn=$qcol4 . $qrow . "im Jahr " . substr($date_since,0,4)  . $qend;
  }
  else if (($type_since == 300100000) && ($type_until == 300500000))
  {
    $qreturn=$qcol4 . $qrow . "vom " . format_date ($date_since) . $qend;
  }
  else if (($type_since == 300100000) && ($type_until == 300100000))
  {
    if ($date_since == $date_until)
    {
      $qreturn=$qcol4 . $qrow . "am " . format_date ($date_since) . $qend;
    }
    else
    {
      $qreturn=$qcol2 . $qrow . "vom " . format_date ($date_since) . $qend .
               $qcol2 . $qrow . "bis " . format_date ($date_until) . $qend
      ;
    }
  }
  else
  {
    if ($date_since=='') {$date_since="&nbsp;";}
    if ($type_since=='') {$type_since="&nbsp;";}
    $qreturn=$qcol1 . $qrow . $date_since . $qend .
             $qcol1 . $qrow . $type_since . $qend .
             $qcol1 . $qrow . $date_until . $qend .
             $qcol1 . $qrow . $type_until . $qend
    ;
  }
  return $qreturn;
}
// Function trans_type
//   Ausgabe eines Texte statt einer Typ-Nummer
//   aus Performancegründen wird nicht aus der Tabelle 
//   geodb_typ_names gelesen.
// Parameter
//   $qtype    zu übersetzende Typ-Id
// Returnwert
//   Textstring 
// Änderung zu 0.8 Ergänzungen von neuen Werten
function trans_type ($qtype)
{
  if      ($qtype==200100000)
  {
    return "WGS84-Koordinaten";
  }
  else if ($qtype==400100000)
  {
    return "Teil von";
  }
  else if ($qtype==400200000)
  {
    return "Ebene";
  }
  else if ($qtype==400300000)
  {
    return "Typ";
  }
  else if ($qtype==500100000)
  {
    return "Name";
  }
  else if ($qtype==500100001)
  {
    return "ISO 3166 Alpha 2";
  }
  else if ($qtype==500100002)
  {
    return "Sortierwert";
  }
  else if ($qtype==500100003)
  {
    return "ISO 3166 2";
  }
  else if ($qtype==500300000)
  {
    return "Postleitzahl";
  }
  else if ($qtype==500400000)
  {
    return "lokale Telefonvorwahl";
  }
  else if ($qtype==500500000)
  {
    return "Autokennzeichen";
  }
  else if ($qtype==500600000)
  {
    return "Amtlicher Gemeindeschl&uuml;ssel";
  }
  else if ($qtype==500700000)
  {
    return "Verwaltungszusammenschlu&szlig;";
  }
  else if ($qtype==600700000)
  {
    return "Einwohneranzahl";
  }
  else if ($qtype==610000000)
  {
    return "Fläche";
  }
  else if ($qtype==650700001)
  {
    return "(gesch&auml;tzt)";
  }
  else if ($qtype==650700002)
  {
    return "(exakt)";
  }
  else
  {
		// Aus Performancegründen wird verzichtet zusätzlich in der 
		// Tabelle geodb_type_names nachzuschlagen
    return $qtype;
  }
}
// Function trans_date
// gibt ein DB-Datum in der Form yyyymmdd
// als deutsche Schreibweise dd.mm.yyyy aus
// Returnwert
//   übergebenes Datum in deutscher Schreibweise
function format_date ($date)
{
  return substr($date,8,2) . "." .
         substr($date,5,2) . "." .
         substr($date,0,4)
  ;
}
// Function show_folgeobject
// gibt das Folgeobject im naechsten Level heraus.
// Ist dieser Level mit 0 (numerisch Null) oder -1
// belegt, wird signalisert, dass eine erneute 
// Abfrage mit Level tiefer sinnvoll ist.
// Parameter
//   $loc_id  zu diesme oBjekt wird das Folgeobjekt gesucht
//   $level   auf diesme level befindet sich das Objekt
//   $count   auf diesem Level soll die Folgeobjekte 
//            gesucht werden
// Returnwert
//   false    Suche ist beendet
//   true     eine Level tiefer ist sinnvoll
function show_folgeobject ($loc_id, $level, $count)
{
 
  global $conn;
  global $arr_tables; // modified 0.9
  $sql =   'SELECT DISTINCT loc_id'
         . '  FROM '.$arr_tables[1]
         . ' WHERE '.$arr_tables[1].'.id_lvl' .$level.'=' . $loc_id
         ;
  $flag=true;
  while ($count>0) {
    if ($flag) {
      $sql = $sql . '   AND '.$arr_tables[1].'.id_lvl' .($level+$count+1).' is null';
      $sql = $sql . '   AND '.$arr_tables[1].'.id_lvl' .($level+$count).' is not null';
      $flag=false;
    } else {
      $sql = $sql . '   AND '.$arr_tables[1].'.id_lvl' .($level+$count).' <=0';
    }
    $count--;
  }
  $sql    = $sql . ' ORDER BY loc_id';
  // echo $sql . "<br />"; // Zum Debuggen
  $result = mysql_query($sql, $conn);
  $num    = mysql_num_rows($result);
  // echo "Anzahl DS: " . $num . "<br />"; // Zum Debuggen
  $flag=true; // Jetzt Rückgabewert
  if ($num > 0)
  {
    $flag=false;
    for ($i=0; $i<$num; $i++)
    {
      $qloc_id=mysql_result($result, $i, "loc_id");
      if ($qloc_id <= 0) {
        $flag = true;
        // echo trans_object ($qloc_id, cIDonly) . "<br />";
      } else {
        echo trans_object ($qloc_id, cText) . "<br />";
      }
    }
  }
  return $flag;
}
?>
</body>
</html> 
